<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\BinaryAuthorization;

class VulnerabilityCheck extends \Google\Collection
{
  protected $collection_key = 'containerAnalysisVulnerabilityProjects';
  /**
   * @var string[]
   */
  public $allowedCves;
  /**
   * @var string[]
   */
  public $blockedCves;
  /**
   * @var string[]
   */
  public $containerAnalysisVulnerabilityProjects;
  /**
   * @var string
   */
  public $maximumFixableSeverity;
  /**
   * @var string
   */
  public $maximumUnfixableSeverity;

  /**
   * @param string[]
   */
  public function setAllowedCves($allowedCves)
  {
    $this->allowedCves = $allowedCves;
  }
  /**
   * @return string[]
   */
  public function getAllowedCves()
  {
    return $this->allowedCves;
  }
  /**
   * @param string[]
   */
  public function setBlockedCves($blockedCves)
  {
    $this->blockedCves = $blockedCves;
  }
  /**
   * @return string[]
   */
  public function getBlockedCves()
  {
    return $this->blockedCves;
  }
  /**
   * @param string[]
   */
  public function setContainerAnalysisVulnerabilityProjects($containerAnalysisVulnerabilityProjects)
  {
    $this->containerAnalysisVulnerabilityProjects = $containerAnalysisVulnerabilityProjects;
  }
  /**
   * @return string[]
   */
  public function getContainerAnalysisVulnerabilityProjects()
  {
    return $this->containerAnalysisVulnerabilityProjects;
  }
  /**
   * @param string
   */
  public function setMaximumFixableSeverity($maximumFixableSeverity)
  {
    $this->maximumFixableSeverity = $maximumFixableSeverity;
  }
  /**
   * @return string
   */
  public function getMaximumFixableSeverity()
  {
    return $this->maximumFixableSeverity;
  }
  /**
   * @param string
   */
  public function setMaximumUnfixableSeverity($maximumUnfixableSeverity)
  {
    $this->maximumUnfixableSeverity = $maximumUnfixableSeverity;
  }
  /**
   * @return string
   */
  public function getMaximumUnfixableSeverity()
  {
    return $this->maximumUnfixableSeverity;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(VulnerabilityCheck::class, 'Google_Service_BinaryAuthorization_VulnerabilityCheck');
