<?php
defined('FIR') OR exit();
/**
 * The template for displaying the footer section
 */
?>
<!-- sidebar section -->
<!-- Sidebar Start -->
<div class="side-navbar active-nav d-flex justify-content-between flex-wrap flex-column" id="sidebar">
    <div class="bg-secondary vh-100 position-fixed d-flex flex-column w-inherit drop-parent">
        <div>
            <a href="<?=$this->siteUrl()?>">
                <img class="ml-40 mt-20 pay-logo img-fluid" src="<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/logo/<?=e($this->siteSettings('logo'))?>" alt="Pay Money" />
            </a>
        </div>

        <div class="flex-grow-1 px-4 px-res mt-43 bg-secondary position-relative overflow-auto hide-thin-scrollbar thin-scrollbar">
            <ul class="list-unstyled ps-0 accordion accordion-flush position-absolute w-268" id="accordion-menu">
                <!-- Dashboard -->
                <li>
                    <a href="<?=$this->siteUrl()?>/user/dashboard" class="mb-1 d-flex align-items-center list-option h-46 mt-7 <?php echo $data['url'] === "dashboard" ? 'text-white bg-info' : 'text-info-100'; ?>">
                        <span class="ms-3 mr-20">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M10.8611 13.8016H4.98016C4.7202 13.8016 4.4709 13.9049 4.28708 14.0887C4.10327 14.2725 4 14.5218 4 14.7817V20.6627C4 20.9227 4.10327 21.172 4.28708 21.3558C4.4709 21.5396 4.7202 21.6429 4.98016 21.6429H10.8611C11.1211 21.6429 11.3704 21.5396 11.5542 21.3558C11.738 21.172 11.8413 20.9227 11.8413 20.6627V14.7817C11.8413 14.5218 11.738 14.2725 11.5542 14.0887C11.3704 13.9049 11.1211 13.8016 10.8611 13.8016ZM9.88095 19.6825H5.96032V15.7619H9.88095V19.6825ZM20.6627 4H14.7817C14.5218 4 14.2725 4.10327 14.0887 4.28708C13.9049 4.4709 13.8016 4.7202 13.8016 4.98016V10.8611C13.8016 11.1211 13.9049 11.3704 14.0887 11.5542C14.2725 11.738 14.5218 11.8413 14.7817 11.8413H20.6627C20.9227 11.8413 21.172 11.738 21.3558 11.5542C21.5396 11.3704 21.6429 11.1211 21.6429 10.8611V4.98016C21.6429 4.7202 21.5396 4.4709 21.3558 4.28708C21.172 4.10327 20.9227 4 20.6627 4ZM19.6825 9.88095H15.7619V5.96032H19.6825V9.88095ZM20.6627 16.7421H18.7024V14.7817C18.7024 14.5218 18.5991 14.2725 18.4153 14.0887C18.2315 13.9049 17.9822 13.8016 17.7222 13.8016C17.4623 13.8016 17.213 13.9049 17.0291 14.0887C16.8453 14.2725 16.7421 14.5218 16.7421 14.7817V16.7421H14.7817C14.5218 16.7421 14.2725 16.8453 14.0887 17.0291C13.9049 17.213 13.8016 17.4623 13.8016 17.7222C13.8016 17.9822 13.9049 18.2315 14.0887 18.4153C14.2725 18.5991 14.5218 18.7024 14.7817 18.7024H16.7421V20.6627C16.7421 20.9227 16.8453 21.172 17.0291 21.3558C17.213 21.5396 17.4623 21.6429 17.7222 21.6429C17.9822 21.6429 18.2315 21.5396 18.4153 21.3558C18.5991 21.172 18.7024 20.9227 18.7024 20.6627V18.7024H20.6627C20.9227 18.7024 21.172 18.5991 21.3558 18.4153C21.5396 18.2315 21.6429 17.9822 21.6429 17.7222C21.6429 17.4623 21.5396 17.213 21.3558 17.0291C21.172 16.8453 20.9227 16.7421 20.6627 16.7421ZM10.8611 4H4.98016C4.7202 4 4.4709 4.10327 4.28708 4.28708C4.10327 4.4709 4 4.7202 4 4.98016V10.8611C4 11.1211 4.10327 11.3704 4.28708 11.5542C4.4709 11.738 4.7202 11.8413 4.98016 11.8413H10.8611C11.1211 11.8413 11.3704 11.738 11.5542 11.5542C11.738 11.3704 11.8413 11.1211 11.8413 10.8611V4.98016C11.8413 4.7202 11.738 4.4709 11.5542 4.28708C11.3704 4.10327 11.1211 4 10.8611 4ZM9.88095 9.88095H5.96032V5.96032H9.88095V9.88095Z" fill="<?php echo $data['url'] === "dashboard" ? '#FFAF30 ' : '#C1BFDF'; ?>"/>
                            </svg>
                        </span>
                        <span>Dashboard</span>
                    </a>
                </li>

                <!-- Wallets -->
                <li>
                    <a href="<?=$this->siteUrl()?>/user/wallets" class="mb-1 d-flex align-items-center list-option h-46 mt-7 <?php echo $data['url'] === "wallets" ? 'text-white bg-info' : 'text-info-100'; ?>">
                        <span class="ms-3 mr-20">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M7.44369 5.6875L16.9313 5.6875C17.3596 5.68749 17.7291 5.68748 18.0335 5.71234C18.3547 5.73859 18.6742 5.79653 18.9816 5.95317C19.4402 6.18687 19.8131 6.55976 20.0468 7.0184C20.2035 7.32583 20.2614 7.64532 20.2877 7.96654C20.3125 8.27088 20.3125 8.64037 20.3125 9.06867V10.2956C21.1151 10.5791 21.7213 11.2668 21.8907 12.1182C21.938 12.3562 21.9378 12.6225 21.9375 12.9319C21.9375 12.9543 21.9375 12.9771 21.9375 13C21.9375 13.023 21.9375 13.0457 21.9375 13.0682C21.9378 13.3775 21.938 13.6438 21.8907 13.8818C21.7213 14.7332 21.1151 15.4209 20.3125 15.7044V16.9313C20.3125 17.3596 20.3125 17.7291 20.2877 18.0335C20.2614 18.3547 20.2035 18.6742 20.0468 18.9816C19.8131 19.4402 19.4402 19.8131 18.9816 20.0468C18.6742 20.2035 18.3547 20.2614 18.0335 20.2877C17.7291 20.3125 17.3596 20.3125 16.9313 20.3125L7.44367 20.3125C7.01537 20.3125 6.64588 20.3125 6.34154 20.2877C6.02032 20.2614 5.70083 20.2035 5.3934 20.0468C4.93475 19.8131 4.56186 19.4402 4.32817 18.9816C4.17153 18.6742 4.11358 18.3547 4.08734 18.0335C4.06247 17.7291 4.06249 17.3596 4.0625 16.9313V9.06868C4.06249 8.64038 4.06247 8.27088 4.08734 7.96654C4.11358 7.64532 4.17153 7.32583 4.32817 7.0184C4.56186 6.55975 4.93475 6.18686 5.3934 5.95317C5.70083 5.79653 6.02032 5.73858 6.34154 5.71234C6.64588 5.68747 7.01538 5.68749 7.44369 5.6875ZM18.6875 15.8438H17.4688C17.4458 15.8438 17.4231 15.8438 17.4006 15.8438C17.0913 15.844 16.8249 15.8442 16.587 15.7969C15.62 15.6046 14.8642 14.8487 14.6718 13.8818C14.6245 13.6438 14.6247 13.3775 14.625 13.0682C14.625 13.0457 14.625 13.023 14.625 13C14.625 12.9771 14.625 12.9543 14.625 12.9318C14.6247 12.6225 14.6245 12.3562 14.6718 12.1182C14.8642 11.1513 15.62 10.3954 16.587 10.2031C16.8249 10.1558 17.0913 10.156 17.4006 10.1562C17.4231 10.1562 17.4458 10.1563 17.4688 10.1563H18.6875V9.1C18.6875 8.63155 18.6869 8.32908 18.6681 8.09887C18.65 7.87814 18.6194 7.79631 18.5989 7.75613C18.521 7.60325 18.3968 7.47896 18.2439 7.40106C18.2037 7.38059 18.1219 7.34998 17.9011 7.33194C17.6709 7.31313 17.3684 7.3125 16.9 7.3125H7.475C7.00655 7.3125 6.70408 7.31313 6.47387 7.33194C6.25314 7.34998 6.17131 7.38059 6.13113 7.40106C5.97825 7.47896 5.85396 7.60325 5.77606 7.75613C5.75559 7.79631 5.72498 7.87814 5.70694 8.09887C5.68813 8.32908 5.6875 8.63155 5.6875 9.1V16.9C5.6875 17.3685 5.68813 17.6709 5.70694 17.9011C5.72498 18.1219 5.75559 18.2037 5.77606 18.2439C5.85396 18.3967 5.97825 18.521 6.13113 18.5989C6.17131 18.6194 6.25314 18.65 6.47387 18.6681C6.70408 18.6869 7.00655 18.6875 7.475 18.6875L16.9 18.6875C17.3685 18.6875 17.6709 18.6869 17.9011 18.6681C18.1219 18.65 18.2037 18.6194 18.2439 18.5989C18.3968 18.521 18.521 18.3967 18.5989 18.2439C18.6194 18.2037 18.65 18.1219 18.6681 17.9011C18.6869 17.6709 18.6875 17.3685 18.6875 16.9V15.8438ZM17.4688 11.7813C17.0523 11.7813 16.9627 11.7852 16.904 11.7969C16.5817 11.861 16.3297 12.1129 16.2656 12.4352C16.2539 12.4939 16.25 12.5835 16.25 13C16.25 13.4165 16.2539 13.5061 16.2656 13.5648C16.3297 13.8871 16.5817 14.139 16.904 14.2031C16.9627 14.2148 17.0523 14.2188 17.4688 14.2188H19.0938C19.5102 14.2188 19.5998 14.2148 19.6585 14.2031C19.9808 14.139 20.2328 13.8871 20.2969 13.5648C20.3086 13.5061 20.3125 13.4165 20.3125 13C20.3125 12.5835 20.3086 12.4939 20.2969 12.4352C20.2328 12.1129 19.9808 11.861 19.6585 11.7969C19.5998 11.7852 19.5102 11.7813 19.0938 11.7813H17.4688Z" fill="<?php echo $data['url'] === "wallets" ? '#FFAF30 ' : '#C1BFDF'; ?>"/>
                            </svg>
                        </span>
                        <span>Wallets</span>
                    </a>
                </li>

                <!-- Custom Addons Header Menu -->
                <li class="mb-20 d-flex align-items-center text-warning f-13 ml-20 mt-38 gilroy-Semibold res-other text-uppercase">Invest</li>
                <!-- Investments -->
                <li class="accordion-item bg-secondary border-0">
                    <div class="accordion-header" id="flush-headinvestment">
                        <button class="mb-1 shadow-none bg-transparent p-0 d-flex align-items-center list-option h-46 accordion-button accordion-icon collapsed <?php echo $data['url'] === "plans" || $data['url'] === "investments" || $data['url'] === "schemes" ? 'text-white bg-info' : 'text-info-100'; ?>" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseinvestment" aria-expanded="false" aria-controls="flush-collapseinvestment">
                            <span class="ms-3 mr-20">
                                <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M5.78021 7.55C5.78626 7.55543 5.79283 7.56116 5.79994 7.56717C5.93265 7.67947 6.1752 7.81911 6.55002 7.95326C7.29256 8.21901 8.37559 8.4 9.61364 8.4C10.8517 8.4 11.9347 8.21901 12.6773 7.95326C13.0521 7.81911 13.2946 7.67947 13.4273 7.56717C13.4344 7.56116 13.441 7.55543 13.4471 7.55C13.441 7.54457 13.4344 7.53884 13.4273 7.53283C13.2946 7.42053 13.0521 7.28089 12.6773 7.14674C11.9347 6.88099 10.8517 6.7 9.61364 6.7C8.37559 6.7 7.29255 6.88099 6.55002 7.14674C6.1752 7.28089 5.93265 7.42053 5.79994 7.53283C5.79283 7.53884 5.78626 7.54457 5.78021 7.55ZM13.7049 9.37475C13.5636 9.43881 13.4171 9.49739 13.2675 9.55091C12.2909 9.90044 10.9989 10.1 9.61364 10.1C8.22833 10.1 6.93637 9.90044 5.95974 9.55091C5.88132 9.52284 5.80372 9.49338 5.72727 9.46247V10.8961C5.7376 10.9086 5.75443 10.9267 5.78083 10.9505C5.89138 11.05 6.09978 11.1798 6.4327 11.3095C7.09272 11.5666 8.0685 11.7567 9.2101 11.7935C9.34288 11.7978 9.47748 11.8 9.61364 11.8C10.0906 11.8 10.4773 12.1806 10.4773 12.65C10.4773 13.1194 10.0906 13.5 9.61364 13.5C9.45866 13.5 9.3052 13.4975 9.15353 13.4926C7.87414 13.4514 6.69083 13.2383 5.79701 12.8901C5.77369 12.8811 5.75044 12.8718 5.72727 12.8625V14.2963C5.73989 14.3116 5.76224 14.3353 5.79994 14.3672C5.93265 14.4795 6.1752 14.6191 6.55002 14.7533C7.29255 15.019 8.37559 15.2 9.61364 15.2C10.0906 15.2 10.4773 15.5806 10.4773 16.05C10.4773 16.5194 10.0906 16.9 9.61364 16.9C8.22833 16.9 6.93637 16.7004 5.95974 16.3509C5.88132 16.3228 5.80372 16.2934 5.72727 16.2625V17.6963C5.73989 17.7116 5.76224 17.7353 5.79994 17.7672C5.93265 17.8795 6.1752 18.0191 6.55002 18.1533C7.29255 18.419 8.37559 18.6 9.61364 18.6C10.0906 18.6 10.4773 18.9806 10.4773 19.45C10.4773 19.9194 10.0906 20.3 9.61364 20.3C8.22833 20.3 6.93637 20.1004 5.95974 19.7509C5.47498 19.5774 5.02191 19.3507 4.67389 19.0563C4.32868 18.7642 4 18.3257 4 17.75V7.55C4 6.97434 4.32868 6.53585 4.67389 6.24374C5.02191 5.94926 5.47498 5.72259 5.95974 5.54909C6.93637 5.19956 8.22833 5 9.61364 5C10.9989 5 12.2909 5.19956 13.2675 5.54909C13.7523 5.72259 14.2054 5.94926 14.5534 6.24374C14.8986 6.53585 15.2273 6.97434 15.2273 7.55V8.825C15.2273 9.29444 14.8406 9.675 14.3636 9.675C14.0997 9.675 13.8633 9.55843 13.7049 9.37475ZM13.5529 13.075C13.559 13.0804 13.5656 13.0862 13.5727 13.0922C13.7054 13.2045 13.9479 13.3441 14.3227 13.4783C15.0653 13.744 16.1483 13.925 17.3864 13.925C18.6244 13.925 19.7074 13.744 20.45 13.4783C20.8248 13.3441 21.0674 13.2045 21.2001 13.0922C21.2072 13.0862 21.2137 13.0804 21.2198 13.075C21.2137 13.0696 21.2072 13.0638 21.2001 13.0578C21.0674 12.9455 20.8248 12.8059 20.45 12.6717C19.7074 12.406 18.6244 12.225 17.3864 12.225C16.1483 12.225 15.0653 12.406 14.3227 12.6717C13.9479 12.8059 13.7054 12.9455 13.5727 13.0578C13.5656 13.0638 13.559 13.0696 13.5529 13.075ZM21.2727 14.9875C21.1963 15.0184 21.1187 15.0478 21.0403 15.0759C20.0636 15.4254 18.7717 15.625 17.3864 15.625C16.0011 15.625 14.7091 15.4254 13.7325 15.0759C13.654 15.0478 13.5765 15.0184 13.5 14.9875V16.2088C13.5126 16.2241 13.535 16.2478 13.5727 16.2797C13.7054 16.392 13.9479 16.5316 14.3227 16.6658C15.0653 16.9315 16.1483 17.1125 17.3864 17.1125C18.6244 17.1125 19.7074 16.9315 20.45 16.6658C20.8248 16.5316 21.0674 16.392 21.2001 16.2797C21.2378 16.2478 21.2601 16.2241 21.2727 16.2088V14.9875ZM21.2727 18.175C21.1963 18.2059 21.1187 18.2353 21.0403 18.2634C20.0636 18.6129 18.7717 18.8125 17.3864 18.8125C16.0011 18.8125 14.7091 18.6129 13.7325 18.2634C13.654 18.2353 13.5765 18.2059 13.5 18.175V19.3963C13.5126 19.4116 13.535 19.4353 13.5727 19.4672C13.7054 19.5795 13.9479 19.7191 14.3227 19.8533C15.0653 20.119 16.1483 20.3 17.3864 20.3C18.6244 20.3 19.7074 20.119 20.45 19.8533C20.8248 19.7191 21.0674 19.5795 21.2001 19.4672C21.2378 19.4353 21.2601 19.4116 21.2727 19.3963V18.175ZM23 19.45C23 20.0257 22.6713 20.4642 22.3261 20.7563C21.9781 21.0507 21.525 21.2774 21.0403 21.4509C20.0636 21.8004 18.7717 22 17.3864 22C16.0011 22 14.7091 21.8004 13.7325 21.4509C13.2477 21.2774 12.7946 21.0507 12.4466 20.7563C12.1014 20.4642 11.7727 20.0257 11.7727 19.45V13.075C11.7727 12.4993 12.1014 12.0608 12.4466 11.7687C12.7946 11.4743 13.2477 11.2476 13.7325 11.0741C14.7091 10.7246 16.0011 10.525 17.3864 10.525C18.7717 10.525 20.0636 10.7246 21.0403 11.0741C21.525 11.2476 21.9781 11.4743 22.3261 11.7687C22.6713 12.0608 23 12.4993 23 13.075V19.45Z" fill="<?php echo $data['url'] === "plans" || $data['url'] === "investments" || $data['url'] === "schemes" ? '#FFAF30 ' : '#C1BFDF'; ?>"></path>
                                </svg>
                            </span>
                            <span class="child-currency">Investments</span>
                        </button>
                    </div>

                    <div id="flush-collapseinvestment" class="accordion-collapse collapse <?php echo $data['url'] === "plans" || $data['url'] === "investments" || $data['url'] === "schemes" ? 'show ' : ''; ?>" aria-labelledby="flush-headinvestment" data-bs-parent="#accordion-menu">
                        <ul class="accordion-body collapse-child ml-28 p-0 pl-16 mr-20">
                            <!-- Investment Plan List -->
                            <li><a href="<?=$this->siteUrl()?>/user/plans" class="mb-2 ml-34 pl-14 f-14 d-flex align-items-center list-option h-46 <?php echo $data['url'] === "plans" || $data['url'] === "schemes" ? 'text-white bg-info' : 'text-info-100'; ?>">Plans</a></li>

                            <!-- Investment Create -->
                            <li><a href="<?=$this->siteUrl()?>/user/investments" class="mb-2 ml-34 pl-14 f-14 d-flex align-items-center list-option h-46 <?php echo $data['url'] === "investments" ? 'text-white bg-info' : 'text-info-100'; ?>">History</a></li>
                        </ul>
                    </div>
                </li>
                <!-- Custom Addons Header Menu End-->

                <li class="mb-21 d-flex align-items-center res-trans text-warning f-13 ml-20 mt-39 gilroy-Semibold text-uppercase">Transactions</li>

                <!-- Deposit Money -->
                <li class="accordion-item bg-secondary border-0">
                    <div class="accordion-header" id="flush-headtwo">
                        <button class="mb-1 shadow-none bg-transparent p-0 d-flex align-items-center list-option h-46 accordion-button accordion-icon collapsed <?php echo $data['url'] === "deposit" || $data['url'] === "deposits" ? 'text-white bg-info' : 'text-info-100'; ?>" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseDeposit" aria-expanded="false" aria-controls="flush-collapseDeposit">
                            <span class="ms-3 mr-20">
                                <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M7.40483 5H18.5952C19.0265 4.99999 19.3986 4.99997 19.705 5.02548C20.0285 5.05239 20.3502 5.11182 20.6598 5.27249C21.1216 5.51217 21.4971 5.89462 21.7325 6.36503C21.8902 6.68034 21.9486 7.00802 21.975 7.33748C22 7.64962 22 8.02858 22 8.46786V11.6667C22 12.1269 21.6337 12.5 21.1818 12.5C20.7299 12.5 20.3636 12.1269 20.3636 11.6667V10.8333H5.63637V14.8333C5.63637 15.3138 5.637 15.624 5.65594 15.8601C5.6741 16.0865 5.70493 16.1705 5.72554 16.2117C5.80398 16.3685 5.92915 16.4959 6.0831 16.5758C6.12355 16.5968 6.20596 16.6282 6.42823 16.6467C6.66005 16.666 6.96464 16.6667 7.43636 16.6667H13C13.4519 16.6667 13.8182 17.0398 13.8182 17.5C13.8182 17.9602 13.4519 18.3333 13 18.3333H7.40485C6.97354 18.3333 6.60145 18.3334 6.29498 18.3079C5.97151 18.2809 5.64979 18.2215 5.34021 18.0608C4.87835 17.8212 4.50286 17.4387 4.26753 16.9683C4.10979 16.653 4.05144 16.3253 4.02501 15.9959C3.99997 15.6837 3.99999 15.3047 4 14.8655V8.46788C3.99999 8.02859 3.99997 7.64962 4.02501 7.33748C4.05144 7.00802 4.10979 6.68034 4.26753 6.36503C4.50286 5.89462 4.87835 5.51217 5.34021 5.27249C5.64979 5.11182 5.97151 5.05239 6.29498 5.02548C6.60145 4.99997 6.97353 4.99999 7.40483 5ZM5.63637 9.16667H20.3636V8.5C20.3636 8.01954 20.363 7.70931 20.3441 7.4732C20.3259 7.24681 20.2951 7.16288 20.2745 7.12168C20.196 6.96488 20.0709 6.83739 19.9169 6.7575C19.8764 6.7365 19.794 6.7051 19.5718 6.68661C19.3399 6.66732 19.0354 6.66667 18.5636 6.66667H7.43637C6.96464 6.66667 6.66005 6.66732 6.42823 6.68661C6.20596 6.7051 6.12355 6.7365 6.0831 6.7575C5.92915 6.83739 5.80398 6.96487 5.72554 7.12168C5.70493 7.16288 5.6741 7.24681 5.65594 7.4732C5.637 7.70931 5.63637 8.01954 5.63637 8.5V9.16667ZM18.7273 13.3333C19.1791 13.3333 19.5455 13.7064 19.5455 14.1667V17.1548L20.6033 16.0774C20.9228 15.752 21.4408 15.752 21.7604 16.0774C22.0799 16.4028 22.0799 16.9305 21.7604 17.2559L19.3058 19.7559C18.9863 20.0814 18.4683 20.0814 18.1487 19.7559L15.6942 17.2559C15.3747 16.9305 15.3747 16.4028 15.6942 16.0774C16.0137 15.752 16.5317 15.752 16.8513 16.0774L17.9091 17.1548V14.1667C17.9091 13.7064 18.2754 13.3333 18.7273 13.3333Z" fill="<?php echo $data['url'] === "deposit" || $data['url'] === "deposits" ? '#FFAF30 ' : '#C1BFDF'; ?>"></path>
                                </svg>
                            </span>
                            <span class="child-currency">Deposit</span>
                        </button>
                    </div>

                    <div id="flush-collapseDeposit" class="accordion-collapse collapse <?php echo $data['url'] === "deposit" || $data['url'] === "deposits" ? 'show ' : ''; ?>" aria-labelledby="flush-headtwo" data-bs-parent="#accordion-menu">
                        <ul class="accordion-body collapse-child ml-28 p-0 pl-16 mr-20">
                            <!-- Deposit Money -->
                            <li><a href="<?=$this->siteUrl()?>/user/deposit" class="mb-2 ml-34 pl-14 f-14 d-flex align-items-center list-option h-46 <?php echo $data['url'] === "deposit" ? 'text-white bg-info' : 'text-info-100'; ?>">Deposit Money</a></li>

                            <!-- Deposit List -->
                            <li><a href="<?=$this->siteUrl()?>/user/deposits" class="mb-2 ml-34 pl-14 f-14 d-flex align-items-center list-option h-46 <?php echo $data['url'] === "deposits" ? 'text-white bg-info' : 'text-info-100'; ?>">Deposit List</a></li>
                        </ul>
                    </div>
                </li>

                <!-- Withdraw Money -->
                <li class="accordion-item bg-secondary border-0">
                    <div class="accordion-header" id="flush-headtwo">
                        <button class="mb-1 shadow-none bg-transparent p-0 d-flex align-items-center list-option h-46 accordion-button accordion-icon collapsed <?php echo $data['url'] === "payout" || $data['url'] === "payouts" ? 'text-white bg-info' : 'text-info-100'; ?>" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseTwo" aria-expanded="false" aria-controls="flush-collapseTwo">
                            <span class="ms-3 mr-20">
                                <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M7.40483 6H18.5952C19.0265 5.99999 19.3986 5.99997 19.705 6.02548C20.0285 6.05239 20.3502 6.11182 20.6598 6.27249C21.1216 6.51217 21.4971 6.89462 21.7325 7.36503C21.8902 7.68034 21.9486 8.00802 21.975 8.33748C22 8.64962 22 9.02858 22 9.46786V12.6667C22 13.1269 21.6337 13.5 21.1818 13.5C20.7299 13.5 20.3636 13.1269 20.3636 12.6667V11.8333H5.63637V15.8333C5.63637 16.3138 5.637 16.624 5.65594 16.8601C5.6741 17.0865 5.70493 17.1705 5.72554 17.2117C5.80398 17.3685 5.92915 17.4959 6.0831 17.5758C6.12355 17.5968 6.20596 17.6282 6.42823 17.6467C6.66005 17.666 6.96464 17.6667 7.43636 17.6667H13C13.4519 17.6667 13.8182 18.0398 13.8182 18.5C13.8182 18.9602 13.4519 19.3333 13 19.3333H7.40485C6.97354 19.3333 6.60145 19.3334 6.29498 19.3079C5.97151 19.2809 5.64979 19.2215 5.34021 19.0608C4.87835 18.8212 4.50286 18.4387 4.26753 17.9683C4.10979 17.653 4.05144 17.3253 4.02501 16.9959C3.99997 16.6837 3.99999 16.3047 4 15.8655V9.46788C3.99999 9.02859 3.99997 8.64962 4.02501 8.33748C4.05144 8.00802 4.10979 7.68034 4.26753 7.36503C4.50286 6.89462 4.87835 6.51217 5.34021 6.27249C5.64979 6.11182 5.97151 6.05239 6.29498 6.02548C6.60145 5.99997 6.97353 5.99999 7.40483 6ZM5.63637 10.1667H20.3636V9.5C20.3636 9.01954 20.363 8.70931 20.3441 8.4732C20.3259 8.24681 20.2951 8.16288 20.2745 8.12168C20.196 7.96488 20.0709 7.83739 19.9169 7.7575C19.8764 7.7365 19.794 7.7051 19.5718 7.68661C19.3399 7.66732 19.0354 7.66667 18.5636 7.66667H7.43637C6.96464 7.66667 6.66005 7.66732 6.42823 7.68661C6.20596 7.7051 6.12355 7.7365 6.0831 7.7575C5.92915 7.83739 5.80398 7.96487 5.72554 8.12168C5.70493 8.16288 5.6741 8.24681 5.65594 8.4732C5.637 8.70931 5.63637 9.01954 5.63637 9.5V10.1667ZM18.1487 14.5774C18.4683 14.252 18.9863 14.252 19.3058 14.5774L21.7604 17.0774C22.0799 17.4028 22.0799 17.9305 21.7604 18.2559C21.4408 18.5814 20.9228 18.5814 20.6033 18.2559L19.5455 17.1785V20.1667C19.5455 20.6269 19.1791 21 18.7273 21C18.2754 21 17.9091 20.6269 17.9091 20.1667V17.1785L16.8513 18.2559C16.5317 18.5814 16.0137 18.5814 15.6942 18.2559C15.3747 17.9305 15.3747 17.4028 15.6942 17.0774L18.1487 14.5774Z" fill="<?php echo $data['url'] === "payout" || $data['url'] === "payouts" ? '#FFAF30 ' : '#C1BFDF'; ?>"/>
                                </svg>
                            </span>
                            <span class="child-currency">Withdrawals</span>
                        </button>
                    </div>

                    <div id="flush-collapseTwo" class="accordion-collapse collapse <?php echo $data['url'] === "payout" || $data['url'] === "payouts" ? 'show ' : ''; ?>" aria-labelledby="flush-headtwo" data-bs-parent="#accordion-menu">
                        <ul class="accordion-body collapse-child ml-28 p-0 pl-16 mr-20">
                            <!-- Withdraw Money -->
                            <li><a href="<?=$this->siteUrl()?>/user/payout" class="mb-2 ml-34 pl-14 f-14 d-flex align-items-center list-option h-46 <?php echo $data['url'] === "payout" ? 'text-white bg-info' : 'text-info-100'; ?>">Withdraw Money</a></li>

                            <!-- Withdraw List -->
                            <li><a href="<?=$this->siteUrl()?>/user/payouts" class="mb-2 ml-34 pl-14 f-14 d-flex align-items-center list-option h-46 <?php echo $data['url'] === "payouts" ? 'text-white bg-info' : 'text-info-100'; ?>">Withdrawal List</a></li>
                        </ul>
                    </div>
                </li>

                <!-- Loan -->
                <li class="accordion-item bg-secondary border-0">
                    <div class="accordion-header" id="flush-headtwo">
                        <button class="mb-1 shadow-none bg-transparent p-0 d-flex align-items-center list-option h-46 accordion-button accordion-icon collapsed <?php echo $data['url'] === "loan" || $data['url'] === "loans" ? 'text-white bg-info' : 'text-info-100'; ?>" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseLoan" aria-expanded="false" aria-controls="flush-collapseLoan">
                            <span class="ms-3 mr-20">
                                <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="none" class="bi bi-bank" viewBox="0 0 26 26">
                                    <path d="m8 0 6.61 3h.89a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-.5.5H15v7a.5.5 0 0 1 .485.38l.5 2a.498.498 0 0 1-.485.62H.5a.498.498 0 0 1-.485-.62l.5-2A.5.5 0 0 1 1 13V6H.5a.5.5 0 0 1-.5-.5v-2A.5.5 0 0 1 .5 3h.89zM3.777 3h8.447L8 1zM2 6v7h1V6zm2 0v7h2.5V6zm3.5 0v7h1V6zm2 0v7H12V6zM13 6v7h1V6zm2-1V4H1v1zm-.39 9H1.39l-.25 1h13.72z" fill="<?php echo $data['url'] === "loan" || $data['url'] === "loans" ? '#FFAF30 ' : '#C1BFDF'; ?>"/>
                                </svg>
                            </span>
                            <span class="child-currency">Loan</span>
                        </button>
                    </div>

                    <div id="flush-collapseLoan" class="accordion-collapse collapse <?php echo $data['url'] === "loan" || $data['url'] === "loans" ? 'show ' : ''; ?>" aria-labelledby="flush-headtwo" data-bs-parent="#accordion-menu">
                        <ul class="accordion-body collapse-child ml-28 p-0 pl-16 mr-20">
                            <!-- Loan Money -->
                            <li><a href="<?=$this->siteUrl()?>/user/loan" class="mb-2 ml-34 pl-14 f-14 d-flex align-items-center list-option h-46 <?php echo $data['url'] === "loan" ? 'text-white bg-info' : 'text-info-100'; ?>">Request Loan</a></li>

                            <!-- Loan List -->
                            <li><a href="<?=$this->siteUrl()?>/user/loans" class="mb-2 ml-34 pl-14 f-14 d-flex align-items-center list-option h-46 <?php echo $data['url'] === "loans" ? 'text-white bg-info' : 'text-info-100'; ?>">Loan List</a></li>
                        </ul>
                    </div>
                </li>

                <?php if (e($data['settings']['b_transfer']) == 1) : ?>
                <!-- Send Money -->
                <li>
                    <a href="<?=$this->siteUrl()?>/user/send" class="mb-1 d-flex align-items-center list-option h-46 mt-7 <?php echo $data['url'] === "send" ? 'text-white bg-info' : 'text-info-100'; ?>">
                        <span class="ms-3 mr-20">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M5.46393 5.03937C5.31364 5.10324 5.107 5.30989 5.04688 5.46393C4.93041 5.74197 4.94168 5.78706 6.16653 9.46536L7.34254 12.9896L6.16277 16.5252C5.05815 19.8465 4.98677 20.072 5.0018 20.2786C5.03185 20.6882 5.3174 20.9587 5.74572 20.985L5.9937 21L13.3203 17.3367C18.5541 14.7217 20.6844 13.6359 20.7746 13.5495C20.9361 13.3879 21 13.2263 21 12.9896C21 12.7529 20.9361 12.5914 20.7746 12.4298C20.6844 12.3434 18.5541 11.2613 13.3278 8.64629C6.13272 5.05064 6.00497 4.98677 5.79081 4.98677C5.67434 4.99053 5.52405 5.01307 5.46393 5.03937ZM12.7905 10.1792C15.8601 11.7159 18.37 12.9784 18.37 12.9896C18.37 13.0159 7.20728 18.5954 7.18849 18.5766C7.18098 18.5691 7.53416 17.4908 7.97375 16.1795L8.77028 13.7974L11.0284 13.7786L13.2864 13.7599L13.433 13.6584C13.5119 13.6021 13.6208 13.4931 13.6734 13.4142C13.7523 13.2977 13.7674 13.2338 13.7674 12.9896C13.7674 12.7379 13.7561 12.6853 13.6659 12.5538C13.6096 12.4749 13.5006 12.3659 13.4217 12.3133L13.2827 12.2194L11.0284 12.2006L8.77028 12.1818L7.97375 9.81478C7.53791 8.51103 7.17722 7.43647 7.17722 7.41768C7.17346 7.40266 7.18098 7.39138 7.19225 7.39138C7.20352 7.39138 9.72085 8.64629 12.7905 10.1792Z" fill="<?php echo $data['url'] === "send" ? '#FFAF30 ' : '#C1BFDF'; ?>"
                                />
                            </svg>
                        </span>
                        <span>Send Money</span>
                    </a>
                </li>
                <?php endif; ?>

                <?php if (e($data['settings']['b_request']) == 1) : ?>
                <!-- Request Money -->
                <li>
                    <a href="<?=$this->siteUrl()?>/user/request" class="mb-1 d-flex align-items-center list-option h-46 mt-7 <?php echo $data['url'] === "request" ? 'text-white bg-info' : 'text-info-100'; ?>">
                        <span class="ms-3 mr-20">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M18.2894 15.5699V9.74756C18.2853 8.44269 17.4143 6.5 15.0313 6.5V4.875L11.7813 7.3125L15.0313 9.75V8.125C16.5173 8.125 16.6571 9.37544 16.6644 9.75V15.5699C15.4944 15.9226 14.6331 16.9975 14.6331 18.2812C14.6331 19.8494 15.9088 21.125 17.4769 21.125C19.045 21.125 20.3206 19.8494 20.3206 18.2812C20.3206 16.9975 19.4594 15.9226 18.2894 15.5699V15.5699ZM17.4769 19.5C16.8049 19.5 16.2581 18.9532 16.2581 18.2812C16.2581 17.6093 16.8049 17.0625 17.4769 17.0625C18.1488 17.0625 18.6956 17.6093 18.6956 18.2812C18.6956 18.9532 18.1488 19.5 17.4769 19.5ZM10.5625 7.71875C10.5625 6.15063 9.28688 4.875 7.71875 4.875C6.15063 4.875 4.875 6.15063 4.875 7.71875C4.875 9.0025 5.73625 10.0774 6.90625 10.4301V15.5699C5.73625 15.9226 4.875 16.9975 4.875 18.2812C4.875 19.8494 6.15063 21.125 7.71875 21.125C9.28688 21.125 10.5625 19.8494 10.5625 18.2812C10.5625 16.9975 9.70125 15.9226 8.53125 15.5699V10.4301C9.70125 10.0774 10.5625 9.0025 10.5625 7.71875ZM6.5 7.71875C6.5 7.04681 7.04681 6.5 7.71875 6.5C8.39069 6.5 8.9375 7.04681 8.9375 7.71875C8.9375 8.39069 8.39069 8.9375 7.71875 8.9375C7.04681 8.9375 6.5 8.39069 6.5 7.71875ZM8.9375 18.2812C8.9375 18.9532 8.39069 19.5 7.71875 19.5C7.04681 19.5 6.5 18.9532 6.5 18.2812C6.5 17.6093 7.04681 17.0625 7.71875 17.0625C8.39069 17.0625 8.9375 17.6093 8.9375 18.2812Z" fill="<?php echo $data['url'] === "request" ? '#FFAF30 ' : '#C1BFDF'; ?>"
                                />
                            </svg>
                        </span>
                        <span>Request Money</span>
                    </a>
                </li>
                <?php endif; ?>

                <!-- Transactions -->
                <li>
                    <a href="<?=$this->siteUrl()?>/user/transactions" class="mb-1 d-flex align-items-center list-option h-46 mt-7 <?php echo $data['url'] === "transactions" ? 'text-white bg-info' : 'text-info-100'; ?>">
                        <span class="ms-3 mr-20">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M19.5 4.875H11.375C10.7285 4.875 10.1085 5.13181 9.65143 5.58893C9.19431 6.04605 8.9375 6.66603 8.9375 7.3125V13C8.9375 13.6465 9.19431 14.2665 9.65143 14.7236C10.1085 15.1807 10.7285 15.4375 11.375 15.4375H19.5C20.1465 15.4375 20.7665 15.1807 21.2236 14.7236C21.6807 14.2665 21.9375 13.6465 21.9375 13V7.3125C21.9375 6.66603 21.6807 6.04605 21.2236 5.58893C20.7665 5.13181 20.1465 4.875 19.5 4.875ZM20.3125 13C20.3125 13.2155 20.2269 13.4222 20.0745 13.5745C19.9222 13.7269 19.7155 13.8125 19.5 13.8125H11.375C11.1595 13.8125 10.9528 13.7269 10.8005 13.5745C10.6481 13.4222 10.5625 13.2155 10.5625 13V7.3125C10.5625 7.09701 10.6481 6.89035 10.8005 6.73798C10.9528 6.5856 11.1595 6.5 11.375 6.5H19.5C19.7155 6.5 19.9222 6.5856 20.0745 6.73798C20.2269 6.89035 20.3125 7.09701 20.3125 7.3125V13ZM17.4688 9.75C17.168 9.75102 16.8783 9.86398 16.6562 10.0669C16.4815 9.90807 16.2645 9.80344 16.0314 9.76568C15.7983 9.72793 15.5593 9.75868 15.3434 9.85421C15.1275 9.94973 14.944 10.1059 14.8152 10.3038C14.6863 10.5016 14.6178 10.7327 14.6178 10.9688C14.6178 11.2048 14.6863 11.4359 14.8152 11.6337C14.944 11.8316 15.1275 11.9878 15.3434 12.0833C15.5593 12.1788 15.7983 12.2096 16.0314 12.1718C16.2645 12.1341 16.4815 12.0294 16.6562 11.8706C16.803 12.004 16.98 12.0995 17.172 12.149C17.364 12.1984 17.5652 12.2003 17.7581 12.1544C17.951 12.1085 18.1297 12.0162 18.2789 11.8856C18.4281 11.755 18.5431 11.5899 18.614 11.4048C18.685 11.2196 18.7097 11.02 18.686 10.8231C18.6623 10.6263 18.5909 10.4382 18.4781 10.2751C18.3653 10.1121 18.2144 9.97906 18.0385 9.88755C17.8626 9.79604 17.667 9.74883 17.4688 9.75ZM16.25 17.0625C16.0345 17.0625 15.8278 17.1481 15.6755 17.3005C15.5231 17.4528 15.4375 17.6595 15.4375 17.875V18.6875C15.4375 18.903 15.3519 19.1097 15.1995 19.262C15.0472 19.4144 14.8405 19.5 14.625 19.5H6.5C6.28451 19.5 6.07785 19.4144 5.92548 19.262C5.7731 19.1097 5.6875 18.903 5.6875 18.6875V15.4375H6.5C6.71549 15.4375 6.92215 15.3519 7.07452 15.1995C7.2269 15.0472 7.3125 14.8405 7.3125 14.625C7.3125 14.4095 7.2269 14.2028 7.07452 14.0505C6.92215 13.8981 6.71549 13.8125 6.5 13.8125H5.6875V13C5.6875 12.7845 5.7731 12.5778 5.92548 12.4255C6.07785 12.2731 6.28451 12.1875 6.5 12.1875C6.71549 12.1875 6.92215 12.1019 7.07452 11.9495C7.2269 11.7972 7.3125 11.5905 7.3125 11.375C7.3125 11.1595 7.2269 10.9528 7.07452 10.8005C6.92215 10.6481 6.71549 10.5625 6.5 10.5625C5.85353 10.5625 5.23355 10.8193 4.77643 11.2764C4.31931 11.7335 4.0625 12.3535 4.0625 13V18.6875C4.0625 19.334 4.31931 19.954 4.77643 20.4111C5.23355 20.8682 5.85353 21.125 6.5 21.125H14.625C15.2715 21.125 15.8915 20.8682 16.3486 20.4111C16.8057 19.954 17.0625 19.334 17.0625 18.6875V17.875C17.0625 17.6595 16.9769 17.4528 16.8245 17.3005C16.6722 17.1481 16.4655 17.0625 16.25 17.0625ZM8.125 17.875H8.9375C9.15299 17.875 9.35965 17.7894 9.51202 17.637C9.6644 17.4847 9.75 17.278 9.75 17.0625C9.75 16.847 9.6644 16.6403 9.51202 16.488C9.35965 16.3356 9.15299 16.25 8.9375 16.25H8.125C7.90951 16.25 7.70285 16.3356 7.55048 16.488C7.3981 16.6403 7.3125 16.847 7.3125 17.0625C7.3125 17.278 7.3981 17.4847 7.55048 17.637C7.70285 17.7894 7.90951 17.875 8.125 17.875Z" fill="<?php echo $data['url'] === "transactions" ? '#FFAF30 ' : '#C1BFDF'; ?>"/>
                            </svg>
                        </span>
                        <span>Transactions</span>
                    </a>
                </li>

                <li class="mb-20 d-flex align-items-center text-warning f-13 ml-20 mt-38 gilroy-Semibold res-other text-uppercase">Referrals</li>
                <!-- Referred Users -->
                <li>
                    <a href="<?=$this->siteUrl()?>/user/referrals" class="mb-1 d-flex align-items-center list-option h-46 mt-7 <?php echo $data['url'] === "referrals" ? 'text-white bg-info' : 'text-info-100'; ?>">
                        <span class="ms-3 mr-20">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M16.375 5C16.806 5 17.2193 5.1712 17.524 5.47595C17.8288 5.7807 18 6.19402 18 6.625H6.625V15.7063C6.19402 15.7063 5.7807 15.5351 5.47595 15.2304C5.1712 14.9256 5 14.5123 5 14.0813V6.625C5 6.19402 5.1712 5.7807 5.47595 5.47595C5.7807 5.1712 6.19402 5 6.625 5H16.375Z" fill="<?php echo $data['url'] === "referrals" ? '#FFAF30 ' : '#C1BFDF'; ?>" />
                                <path d="M14.75 21.25L12.5831 18.9563H9.875C9.44402 18.9563 9.0307 18.7851 8.72595 18.4804C8.4212 18.1756 8.25 17.7623 8.25 17.3313V9.875C8.25 9.44402 8.4212 9.0307 8.72595 8.72595C9.0307 8.4212 9.44402 8.25 9.875 8.25H19.625C20.056 8.25 20.4693 8.4212 20.774 8.72595C21.0788 9.0307 21.25 9.44402 21.25 9.875V17.3313C21.25 17.7623 21.0788 18.1756 20.774 18.4804C20.4693 18.7851 20.056 18.9563 19.625 18.9563H16.9169L14.75 21.25ZM16.2166 17.3313H19.625V9.875H9.875V17.3313H13.2834L14.75 18.8832L16.2166 17.3313Z" fill="<?php echo $data['url'] === "referrals" ? '#FFAF30 ' : '#C1BFDF'; ?>" />
                            </svg>
                        </span>
                        <span>Referrals</span>
                    </a>
                </li>

                <?php if (e($data['settings']['user_ranking']) == 1) : ?>
                <!-- Ranking -->
                <li>
                    <a href="<?=$this->siteUrl()?>/user/ranking" class="mb-1 d-flex align-items-center list-option h-46 mt-7 <?php echo $data['url'] === "ranking" ? 'text-white bg-info' : 'text-info-100'; ?>">
                        <span class="ms-3 mr-20">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M9.83193 4.50863C10.052 4.958 9.86463 5.49995 9.41336 5.71912C7.86039 6.47337 6.58707 7.69782 5.7759 9.21699C4.96473 10.7362 4.65736 12.472 4.89782 14.1759C4.9677 14.671 4.62129 15.1287 4.1241 15.1983C3.62691 15.2679 3.16721 14.9229 3.09733 14.4278C2.80342 12.3454 3.17911 10.2238 4.17054 8.36699C5.16197 6.51023 6.71825 5.01368 8.61632 4.09182C9.06758 3.87265 9.61183 4.05926 9.83193 4.50863ZM16.1681 4.50872C16.3882 4.05935 16.9324 3.87274 17.3837 4.09191C19.2818 5.01377 20.838 6.51032 21.8295 8.36708C22.8209 10.2238 23.1966 12.3455 22.9027 14.4279C22.8328 14.923 22.3731 15.268 21.8759 15.1984C21.3787 15.1288 21.0323 14.6711 21.1022 14.176C21.3426 12.4721 21.0353 10.7362 20.2241 9.21708C19.4129 7.69791 18.1396 6.47346 16.5866 5.71921C16.1354 5.50004 15.948 4.95808 16.1681 4.50872ZM13 8.96835C10.7406 8.96835 8.90903 10.7922 8.90903 13.0421C8.90903 15.2919 10.7406 17.1158 13 17.1158C15.2593 17.1158 17.0909 15.2919 17.0909 13.0421C17.0909 10.7922 15.2593 8.96835 13 8.96835ZM7.09085 13.0421C7.09085 9.79228 9.73644 7.15781 13 7.15781C16.2635 7.15781 18.9091 9.79228 18.9091 13.0421C18.9091 16.2918 16.2635 18.9263 13 18.9263C9.73644 18.9263 7.09085 16.2918 7.09085 13.0421ZM6.92096 19.8337C7.21608 19.4292 7.7846 19.3396 8.19079 19.6334C9.58864 20.6448 11.2721 21.1895 13 21.1895C14.7278 21.1895 16.4113 20.6448 17.8091 19.6334C18.2153 19.3396 18.7838 19.4292 19.0789 19.8337C19.3741 20.2382 19.284 20.8043 18.8778 21.0982C17.1693 22.3343 15.1118 23 13 23C10.8882 23 8.83057 22.3343 7.12208 21.0982C6.71589 20.8043 6.62585 20.2382 6.92096 19.8337Z" fill="<?php echo $data['url'] === "ranking" ? '#FFAF30 ' : '#C1BFDF'; ?>"/>
                            </svg>
                        </span>
                        <span>Ranking</span>
                    </a>
                </li>
                <?php endif; ?>
                
                <li class="mb-20 d-flex align-items-center text-warning f-13 ml-20 mt-38 gilroy-Semibold res-other text-uppercase">Others</li>
                <!-- Profile -->
                <li>
                    <a href="<?=$this->siteUrl()?>/user/profile" class="mb-1 d-flex align-items-center list-option h-46 mt-7 <?php echo $data['url'] === "profile" ? 'text-white bg-info' : 'text-info-100'; ?>">
                        <span class="ms-3 mr-20">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M13.0001 6.33366C11.3892 6.33366 10.0834 7.63949 10.0834 9.25033C10.0834 10.8612 11.3892 12.167 13.0001 12.167C14.6109 12.167 15.9167 10.8612 15.9167 9.25033C15.9167 7.63949 14.6109 6.33366 13.0001 6.33366ZM8.41674 9.25033C8.41674 6.71902 10.4688 4.66699 13.0001 4.66699C15.5314 4.66699 17.5834 6.71902 17.5834 9.25033C17.5834 11.7816 15.5314 13.8337 13.0001 13.8337C10.4688 13.8337 8.41674 11.7816 8.41674 9.25033ZM10.772 15.0836C10.8195 15.0836 10.8678 15.0837 10.9167 15.0837H15.0834C15.1324 15.0837 15.1806 15.0836 15.2282 15.0836C16.2509 15.0832 16.9493 15.083 17.5429 15.2631C18.8746 15.667 19.9167 16.7091 20.3207 18.0408C20.5007 18.6345 20.5005 19.3328 20.5001 20.3555C20.5001 20.4031 20.5001 20.4513 20.5001 20.5003C20.5001 20.9606 20.127 21.3337 19.6667 21.3337C19.2065 21.3337 18.8334 20.9606 18.8334 20.5003C18.8334 19.2767 18.8244 18.8497 18.7258 18.5246C18.4834 17.7256 17.8581 17.1003 17.0591 16.858C16.7341 16.7594 16.307 16.7503 15.0834 16.7503H10.9167C9.69314 16.7503 9.26608 16.7594 8.94102 16.858C8.14202 17.1003 7.51676 17.7256 7.27439 18.5246C7.17578 18.8497 7.16674 19.2767 7.16674 20.5003C7.16674 20.9606 6.79364 21.3337 6.3334 21.3337C5.87317 21.3337 5.50007 20.9606 5.50007 20.5003C5.50007 20.4514 5.50005 20.4031 5.50003 20.3555C5.49966 19.3328 5.4994 18.6345 5.67949 18.0408C6.08344 16.7091 7.12554 15.667 8.45721 15.2631C9.05088 15.083 9.74923 15.0832 10.772 15.0836Z" fill="<?php echo $data['url'] === "profile" ? '#FFAF30 ' : '#C1BFDF'; ?>"/>
                            </svg>
                        </span>
                        <span>Profile</span>
                    </a>
                </li>

                <?php if (e($data['settings']['kyc_status']) == 1) : ?>
                <!-- Verifications -->
                <li>
                    <a href="<?=$this->siteUrl()?>/user/verifications/personal-id" class="mb-1 d-flex align-items-center list-option h-46 mt-7 <?php echo $data['url'] === "verifications" ? 'text-white bg-info' : 'text-info-100'; ?>">
                        <span class="ms-3 mr-20">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M14.9276 4.016C14.8495 4.05071 14.5067 4.40221 14.1248 4.84049L13.4565 5.59989L12.9097 5.60423H12.363L11.699 4.88388C11.3345 4.489 10.9744 4.1375 10.9006 4.09845C10.8268 4.05939 10.688 4.02902 10.5925 4.02902C10.2453 4.02902 9.02596 4.51069 8.40108 4.88822C8.21015 5.00539 8.12336 5.09218 8.05393 5.23104C7.9628 5.42197 7.9628 5.42197 8.03223 6.43306L8.10166 7.44415L7.71979 7.83036L7.33792 8.21223L6.31381 8.18619C5.18122 8.15147 5.13783 8.15581 4.91218 8.4292C4.74294 8.62881 4.39579 9.37519 4.18749 9.99139C3.9792 10.6033 3.94883 10.933 4.07467 11.1283C4.11372 11.1934 4.48258 11.5406 4.88614 11.9007L5.62385 12.556V13.0897V13.6278L4.88614 14.3091C4.47824 14.691 4.12674 15.0512 4.09637 15.1249C4.06599 15.1987 4.04429 15.3376 4.04863 15.433C4.05731 15.7108 4.30032 16.379 4.65181 17.0907C4.99463 17.7893 5.12047 17.9456 5.38952 17.9976C5.47197 18.0107 5.971 17.9976 6.49607 17.9629L7.45075 17.8978L7.84129 18.284L8.23184 18.6703L8.21882 19.7421C8.20581 20.8096 8.20581 20.8139 8.30995 20.9571C8.49221 21.2132 9.85479 21.812 10.6055 21.9682C11.0481 22.0593 11.1349 22.0029 11.89 21.1394L12.5366 20.4017H12.8924C13.0877 20.4017 13.335 20.3887 13.4392 20.3756L13.6301 20.3496L14.3027 21.0743C14.6716 21.4735 15.0317 21.8294 15.1055 21.8684C15.4136 22.0333 16.0949 21.8511 17.158 21.326C17.7699 21.0222 17.9652 20.8573 18.0173 20.5883C18.0303 20.5145 18.0173 20.0242 17.9825 19.5034L17.9218 18.5574L18.2906 18.1539L18.6638 17.746L19.2063 17.772C19.5057 17.7893 19.9787 17.8024 20.2564 17.8067C20.7424 17.811 20.7685 17.8067 20.942 17.6939C21.0983 17.5941 21.1633 17.4943 21.3977 17.0083C21.9184 15.9408 22.118 15.1249 21.9271 14.8342C21.888 14.7734 21.5235 14.4263 21.1156 14.0661L20.3779 13.4109V12.8815V12.352L20.9464 11.8313C21.9835 10.881 22.0529 10.7682 21.9184 10.2735C21.8056 9.86555 21.5756 9.29708 21.3282 8.80673C21.0375 8.22091 20.9637 8.12544 20.7381 8.02563C20.5558 7.94752 20.5211 7.94318 19.5447 8.01261L18.538 8.0777L18.1561 7.69584L17.7742 7.31396L17.809 6.36363C17.848 5.3699 17.8307 5.19632 17.6788 4.98369C17.5009 4.732 15.8215 4.02902 15.2661 3.9726C15.1402 3.95959 15.01 3.97694 14.9276 4.016ZM16.173 5.71705L16.4334 5.83422L16.403 6.81927C16.3813 7.57867 16.3856 7.82168 16.429 7.90413C16.4941 8.02997 17.835 9.36218 17.9608 9.43161C18.0259 9.46632 18.2646 9.46632 18.7897 9.44029C19.1976 9.42293 19.6576 9.40557 19.8138 9.40123H20.0915L20.2781 9.81348C20.3779 10.0391 20.4604 10.2648 20.4604 10.3125C20.4604 10.3689 20.2955 10.5468 19.996 10.8202C19.1802 11.5579 19.037 11.7185 18.998 11.9441C18.9763 12.057 18.9763 12.339 18.9936 12.5734C19.0153 12.812 19.0197 13.1896 19.0023 13.4152C18.9676 13.9967 18.998 14.0488 19.8572 14.8082C20.239 15.1466 20.5515 15.4374 20.5515 15.4504C20.5515 15.4634 20.469 15.6804 20.3649 15.9321L20.1826 16.3877L19.2019 16.3747C18.0086 16.353 18.0433 16.3443 17.5616 16.9041C17.375 17.1211 17.093 17.4031 16.9367 17.5333C16.5028 17.8892 16.4898 17.9369 16.5505 18.9176C16.633 20.176 16.6677 20.0285 16.2294 20.2324C15.6132 20.5145 15.7087 20.5492 15.0014 19.7855C14.6585 19.421 14.3244 19.0868 14.255 19.0391C14.1769 18.9914 14.051 18.961 13.9425 18.961C12.3152 18.9827 12.0636 18.9957 11.9377 19.0651C11.8336 19.1216 10.7357 20.3062 10.6055 20.5015C10.5795 20.5449 10.2106 20.4234 9.77234 20.2281L9.55971 20.1326L9.59008 19.7334C9.63348 19.0955 9.62914 18.1756 9.58141 18.0541C9.55537 17.9933 9.36443 17.7893 9.15614 17.6028C8.94785 17.4162 8.64409 17.1124 8.47485 16.9258C8.27524 16.7002 8.12336 16.57 8.02355 16.5353C7.90639 16.4962 7.65036 16.5005 6.94737 16.5396C6.43966 16.57 5.9927 16.583 5.96232 16.57C5.90591 16.5526 5.53706 15.7368 5.53706 15.637C5.53706 15.6153 5.85384 15.3072 6.24004 14.9514C6.62191 14.5955 6.96039 14.2484 6.99077 14.1789C7.06888 13.9967 7.02548 12.096 6.93869 11.9268C6.90832 11.8617 6.56116 11.5232 6.16627 11.1761L5.45461 10.5468L5.51102 10.3863C5.54574 10.2952 5.63252 10.0695 5.71063 9.88291L5.85384 9.54443L6.27042 9.57047C6.50041 9.58349 6.95171 9.60084 7.27717 9.60518C7.96714 9.61386 8.03223 9.58783 8.34033 9.19728C8.44881 9.05842 8.7222 8.77635 8.94785 8.56806C9.1735 8.35543 9.39047 8.13412 9.42519 8.06903C9.49896 7.92582 9.5033 7.60037 9.4382 6.65437C9.39481 6.05987 9.39481 5.93403 9.44688 5.88629C9.50764 5.82988 10.2627 5.51744 10.3451 5.51744C10.3712 5.51744 10.6793 5.82988 11.0351 6.21175C11.3866 6.59362 11.7381 6.9321 11.8075 6.96681C11.9898 7.04926 13.8688 7.01454 14.064 6.92342C14.1378 6.8887 14.4763 6.54155 14.8148 6.151L15.4396 5.43933L15.674 5.51744C15.8041 5.56518 16.0298 5.65196 16.173 5.71705Z" fill="<?php echo $data['url'] === "verifications" ? '#FFAF30 ' : '#C1BFDF'; ?>"/>
                                <path d="M12.3806 9.57485C9.98525 10.0305 8.78323 12.76 10.0677 14.8256C10.736 15.8887 11.9163 16.5049 13.1747 16.4398C13.7432 16.4095 14.0426 16.3313 14.5417 16.084C15.2533 15.7368 15.7567 15.2335 16.1038 14.5218C16.3512 14.0228 16.4293 13.7233 16.4597 13.1549C16.5248 11.9442 15.952 10.7942 14.9409 10.1086C14.2249 9.62258 13.2268 9.41429 12.3806 9.57485ZM13.4698 10.9635C14.5937 11.2282 15.3141 12.3998 15.019 13.4977C14.8237 14.2397 14.2032 14.8516 13.4785 15.0165C12.0769 15.342 10.736 14.1052 10.9529 12.6906C11.1439 11.4799 12.2982 10.6857 13.4698 10.9635Z" fill="<?php echo $data['url'] === "verifications" ? '#FFAF30 ' : '#C1BFDF'; ?>"/>
                            </svg>
                        </span>
                        <span>Verifications</span>
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</div>
<!-- Sidebar End -->
<!-- end sidebar section -->