<?php
defined('FIR') OR exit();
/**
 * The template for displaying the header section
 */
?>
<!-- header section -->
<nav class="navbar navbar sticky-top top-navbar bg-white p-0">
    <a class="btn border-0 menu-svg" id="menu-btn">
        <svg width="20" height="14" viewBox="0 0 20 14" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M1 7H19M1 1H19M1 13H13" stroke="" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
        </svg>
    </a>

    <div class="border-b-DF d-flex align-items-center w-100 h-70">
        <div class="input-group flex-nowrap search-fill"></div>

        <div class="color-parent form-check form-switch d-flex mr-33">
            <div class="switch d-flex align-items-center justify-content-center">
                <span class="moon-rtl">
                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M8.48582 2.84091C8.67976 3.03564 8.73332 3.33061 8.62031 3.58153C8.26666 4.36671 8.06945 5.23872 8.06945 6.15876C8.06945 9.61707 10.8616 12.4206 14.306 12.4206C15.2223 12.4206 16.0908 12.2226 16.8728 11.8675C17.1227 11.754 17.4165 11.8078 17.6104 12.0025C17.8044 12.1973 17.8579 12.4922 17.7449 12.7432C16.5602 15.3735 13.923 17.2059 10.8582 17.2059C6.68582 17.2059 3.30347 13.8098 3.30347 9.62056C3.30347 6.5433 5.12845 3.89543 7.74819 2.70588C7.9981 2.5924 8.29187 2.64618 8.48582 2.84091ZM6.87136 4.80495C5.49618 5.954 4.62165 7.68514 4.62165 9.62056C4.62165 13.0789 7.41383 15.8824 10.8582 15.8824C12.7858 15.8824 14.5099 15.0043 15.6543 13.6235C15.2166 13.7028 14.7659 13.7441 14.306 13.7441C10.1336 13.7441 6.75127 10.348 6.75127 6.15876C6.75127 5.69694 6.79245 5.24447 6.87136 4.80495Z" fill="currentColor"/>
                    </svg>
                </span>

                <div class="mx-10" id="switch">
                    <input class="form-check-input theme-check m-0" type="checkbox" id="flexSwitchCheckDefault" />
                </div>

                <span class="moon-ltr">
                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M8.48582 2.84091C8.67976 3.03564 8.73332 3.33061 8.62031 3.58153C8.26666 4.36671 8.06945 5.23872 8.06945 6.15876C8.06945 9.61707 10.8616 12.4206 14.306 12.4206C15.2223 12.4206 16.0908 12.2226 16.8728 11.8675C17.1227 11.754 17.4165 11.8078 17.6104 12.0025C17.8044 12.1973 17.8579 12.4922 17.7449 12.7432C16.5602 15.3735 13.923 17.2059 10.8582 17.2059C6.68582 17.2059 3.30347 13.8098 3.30347 9.62056C3.30347 6.5433 5.12845 3.89543 7.74819 2.70588C7.9981 2.5924 8.29187 2.64618 8.48582 2.84091ZM6.87136 4.80495C5.49618 5.954 4.62165 7.68514 4.62165 9.62056C4.62165 13.0789 7.41383 15.8824 10.8582 15.8824C12.7858 15.8824 14.5099 15.0043 15.6543 13.6235C15.2166 13.7028 14.7659 13.7441 14.306 13.7441C10.1336 13.7441 6.75127 10.348 6.75127 6.15876C6.75127 5.69694 6.79245 5.24447 6.87136 4.80495Z" fill="currentColor"/>
                    </svg>
                </span>
            </div>
        </div>

        <div class="notification-drop p-0 d-flex align-items-center">
            <div class="item">
                <div class="d-flex align-items-center">
                    <div class="d-flex align-items-center justify-content-center user-list">
                        <img src="<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/users/<?=e($data['user']['imagelocation'])?>" alt="Profile" class="img-fluid" />
                    </div>

                    <div class="ml-12 d-flex align-items-center h-78 w-134">
                        <p class="mb-0 f-14 text-dark gilroy-Semibold"><?=e($data['user']['firstname'])?> <?=e($data['user']['lastname'])?></p>
                        <span class="ml-13">
                            <svg width="9" height="5" viewBox="0 0 9 5" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M0.401158 0.234532C0.639812 -0.00412146 1.02675 -0.00412146 1.2654 0.234532L4.49995 3.46908L7.73449 0.234532C7.97315 -0.00412146 8.36008 -0.00412146 8.59873 0.234532C8.83739 0.473186 8.83739 0.86012 8.59873 1.09877L4.93207 4.76544C4.69341 5.00409 4.30648 5.00409 4.06783 4.76544L0.401158 1.09877C0.162505 0.86012 0.162505 0.473186 0.401158 0.234532Z" fill="#3F405B"/>
                            </svg>
                        </span>
                    </div>
                </div>

                <ul class="open-notify open-drop bg-white">
                    <li class="d-flex align-items-center bg-secondary h-78 px-3">
                        <div class="d-flex align-items-center justify-content-center user-dp">
                            <img src="<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/users/<?=e($data['user']['imagelocation'])?>" alt="Profile" class="img-fluid" />
                        </div>

                        <div class="ms-3 text-white">
                            <p class="mb-0 f-15 gilroy-medium text-white"><?=e($data['user']['firstname'])?> <?=e($data['user']['lastname'])?></p>
                            <p class="mb-0 f-13 mt-3p gilroy-regular text-info-100" style="text-transform: lowercase;"><?=e($data['user']['email'])?></p>
                        </div>
                    </li>

                    <li class="d-flex align-items-center">
                        <a href="<?=$this->siteUrl()?>/user/profile" class="f-13 gilroy-medium">
                            <svg width="15" height="17" viewBox="0 0 15 17" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M7.5 1.7C5.88918 1.7 4.58336 3.03195 4.58336 4.675C4.58336 6.31805 5.88918 7.65 7.5 7.65C9.11082 7.65 10.4166 6.31805 10.4166 4.675C10.4166 3.03195 9.11082 1.7 7.5 1.7ZM2.91671 4.675C2.91671 2.09307 4.96872 0 7.5 0C10.0313 0 12.0833 2.09307 12.0833 4.675C12.0833 7.25693 10.0313 9.35 7.5 9.35C4.96872 9.35 2.91671 7.25693 2.91671 4.675ZM5.27191 10.625C5.31946 10.625 5.36771 10.625 5.41669 10.625H9.58331C9.63229 10.625 9.68054 10.625 9.72809 10.625C10.7508 10.6246 11.4491 10.6243 12.0428 10.808C13.3745 11.22 14.4166 12.283 14.8205 13.6413C15.0006 14.2468 15.0003 14.9591 15 16.0023C14.9999 16.0508 14.9999 16.1 14.9999 16.15C14.9999 16.6194 14.6268 17 14.1666 17C13.7064 17 13.3333 16.6194 13.3333 16.15C13.3333 14.9019 13.3242 14.4663 13.2256 14.1348C12.9833 13.3198 12.358 12.682 11.559 12.4348C11.234 12.3342 10.8069 12.325 9.58331 12.325H5.41669C4.1931 12.325 3.76604 12.3342 3.44099 12.4348C2.642 12.682 2.01674 13.3198 1.77437 14.1348C1.67577 14.4663 1.66672 14.9019 1.66672 16.15C1.66672 16.6194 1.29363 17 0.833395 17C0.373162 17 6.93952e-05 16.6194 6.93952e-05 16.15C6.93952e-05 16.1 5.1514e-05 16.0508 3.39308e-05 16.0023C-0.000344456 14.9591 -0.000602846 14.2468 0.179484 13.6413C0.583439 12.283 1.62553 11.22 2.95719 10.808C3.55085 10.6243 4.24919 10.6246 5.27191 10.625Z" fill="currentColor"/>
                            </svg>
                            <span class="ms-3">View Profile</span>
                        </a>
                    </li>

                    <li class="d-flex align-items-center">
                        <a href="<?=$this->siteUrl()?>/user/wallets" class="f-13 gilroy-medium">
                            <svg width="17" height="14" viewBox="0 0 17 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M3.21566 6.68974e-07L12.2388 8.54411e-07C12.6462 -1.2497e-05 12.9976 -2.3901e-05 13.287 0.0237793C13.5925 0.0489025 13.8964 0.10437 14.1887 0.254321C14.6249 0.478026 14.9796 0.83498 15.2018 1.27403C15.3508 1.56832 15.4059 1.87416 15.4309 2.18165C15.4545 2.47298 15.4545 2.82668 15.4545 3.23667V4.41114C16.2177 4.68253 16.7943 5.34089 16.9554 6.1559C17.0004 6.38368 17.0002 6.63866 17 6.93477C17 6.95629 16.9999 6.97803 16.9999 7C16.9999 7.02197 17 7.04372 17 7.06526C17.0002 7.36135 17.0004 7.61633 16.9554 7.8441C16.7943 8.65911 16.2177 9.31748 15.4545 9.58886V10.7633C15.4545 11.1733 15.4545 11.527 15.4309 11.8184C15.4059 12.1258 15.3508 12.4317 15.2018 12.726C14.9796 13.165 14.6249 13.522 14.1887 13.7457C13.8964 13.8956 13.5925 13.9511 13.287 13.9762C12.9976 14 12.6462 14 12.2388 14L3.21564 14C2.80831 14 2.45691 14 2.16747 13.9762C1.86198 13.9511 1.55813 13.8956 1.26575 13.7457C0.829554 13.522 0.474918 13.165 0.252667 12.726C0.10369 12.4317 0.0485829 12.1258 0.0236231 11.8184C-2.51275e-05 11.527 -1.31528e-05 11.1733 6.64628e-07 10.7633V3.23669C-1.31528e-05 2.82668 -2.51275e-05 2.47298 0.0236232 2.18165C0.048583 1.87416 0.103691 1.56832 0.252667 1.27402C0.474918 0.834979 0.829554 0.478024 1.26575 0.25432C1.55813 0.104369 1.86198 0.0489007 2.16747 0.0237777C2.45691 -2.52918e-05 2.80832 -1.32388e-05 3.21566 6.68974e-07ZM13.909 9.72222H12.7499C12.7281 9.72222 12.7065 9.72224 12.6851 9.72226C12.391 9.72249 12.1376 9.7227 11.9113 9.67739C10.9917 9.49327 10.2729 8.76971 10.09 7.8441C10.0449 7.61632 10.0451 7.36134 10.0454 7.06525C10.0454 7.04372 10.0454 7.02197 10.0454 7C10.0454 6.97803 10.0454 6.95628 10.0454 6.93476C10.0451 6.63866 10.0449 6.38368 10.09 6.1559C10.2729 5.23029 10.9917 4.50673 11.9113 4.32261C12.1376 4.27731 12.391 4.27751 12.6851 4.27774C12.7065 4.27776 12.7281 4.27778 12.75 4.27778H13.909V3.26667C13.909 2.81824 13.9084 2.52869 13.8905 2.30832C13.8734 2.09703 13.8443 2.01869 13.8248 1.98023C13.7507 1.83388 13.6325 1.7149 13.4871 1.64033C13.4489 1.62074 13.3711 1.59143 13.1612 1.57417C12.9422 1.55616 12.6546 1.55556 12.209 1.55556H3.24544C2.79993 1.55556 2.51226 1.55616 2.29332 1.57417C2.0834 1.59143 2.00557 1.62074 1.96736 1.64033C1.82197 1.7149 1.70376 1.83388 1.62967 1.98023C1.6102 2.01869 1.58109 2.09702 1.56394 2.30832C1.54605 2.52869 1.54545 2.81824 1.54545 3.26667V10.7333C1.54545 11.1818 1.54605 11.4713 1.56394 11.6917C1.58109 11.903 1.6102 11.9813 1.62967 12.0198C1.70376 12.1661 1.82197 12.2851 1.96736 12.3597C2.00557 12.3793 2.0834 12.4086 2.29332 12.4258C2.51226 12.4438 2.79993 12.4444 3.24544 12.4444L12.209 12.4444C12.6546 12.4444 12.9422 12.4438 13.1612 12.4258C13.3711 12.4086 13.4489 12.3793 13.4871 12.3597C13.6325 12.2851 13.7507 12.1661 13.8248 12.0198C13.8443 11.9813 13.8734 11.903 13.8905 11.6917C13.9084 11.4713 13.909 11.1818 13.909 10.7333V9.72222ZM12.75 5.83333C12.3539 5.83333 12.2687 5.8371 12.2128 5.84828C11.9063 5.90965 11.6667 6.15084 11.6057 6.45937C11.5946 6.51557 11.5909 6.60132 11.5909 7C11.5909 7.39868 11.5946 7.48443 11.6057 7.54063C11.6667 7.84916 11.9063 8.09035 12.2128 8.15172C12.2687 8.1629 12.3539 8.16667 12.7499 8.16667H14.2954C14.6915 8.16667 14.7767 8.1629 14.8325 8.15172C15.139 8.09035 15.3787 7.84916 15.4396 7.54063C15.4507 7.48443 15.4545 7.39868 15.4545 7C15.4545 6.60132 15.4507 6.51557 15.4396 6.45937C15.3787 6.15084 15.139 5.90965 14.8325 5.84828C14.7767 5.8371 14.6915 5.83333 14.2954 5.83333H12.75Z" fill="currentColor"/>
                            </svg>
                            <span class="ms-3">Check Wallet</span>
                        </a>
                    </li>

                    <?php if (e($data['settings']['kyc_status']) == 1) : ?>
                    <li class="d-flex align-items-center">
                        <a href="<?=$this->siteUrl()?>/user/verifications/personal-id" class="f-13 gilroy-medium">
                            <svg width="17" height="15" viewBox="0 0 17 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M3.03788 0H1.82273V6.25H3.03788V0ZM10.4503 6.25H6.56183L6.07577 5.5625V4.3125L6.56183 3.75H10.4503L10.9364 4.375V5.625L10.4503 6.25ZM4.37455 10H0.486061L0 9.375V8.125L0.486061 7.5H4.37455L4.86061 8.125V9.375L4.37455 10ZM9.11365 0H7.8985V2.5H9.11365V0ZM7.8985 7.5H9.11365V15H7.8985V7.5ZM3.03788 11.25H1.82273V15H3.03788V11.25ZM12.6376 11.25H16.5139L17 10.625V9.4375L16.5139 8.8125H12.6376L12.1515 9.4375V10.625L12.6376 11.25ZM15.1894 0H13.9743V7.5H15.1894V0ZM13.9743 12.5H15.1894V15H13.9743V12.5Z" fill="currentColor"/>
                            </svg>
                            <span class="ms-3">Verifications</span>
                        </a>
                    </li>
                    <?php endif; ?>

                    <li class="d-flex align-items-center border-top h-63">
                        <a href="<?=$this->siteUrl()?>/user/logout" class="f-13 gilroy-medium">
                            <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M4.03109 3.01904e-07L4.9 6.3569e-07C5.2866 6.3569e-07 5.6 0.313401 5.6 0.700001C5.6 1.0866 5.2866 1.4 4.9 1.4H4.06C3.4604 1.4 3.05279 1.40054 2.73773 1.42629C2.43084 1.45136 2.27389 1.49681 2.16441 1.55259C1.90099 1.68681 1.68681 1.90099 1.55259 2.16441C1.49681 2.27389 1.45136 2.43084 1.42629 2.73773C1.40054 3.05279 1.4 3.46039 1.4 4.06V9.94C1.4 10.5396 1.40054 10.9472 1.42629 11.2623C1.45136 11.5692 1.49681 11.7261 1.55259 11.8356C1.68681 12.099 1.90099 12.3132 2.16441 12.4474C2.27389 12.5032 2.43084 12.5486 2.73773 12.5737C3.05279 12.5995 3.46039 12.6 4.06 12.6H4.9C5.2866 12.6 5.6 12.9134 5.6 13.3C5.6 13.6866 5.2866 14 4.9 14H4.03107C3.4676 14 3.00256 14 2.62372 13.9691C2.23025 13.9369 1.86856 13.8679 1.52883 13.6948C1.00197 13.4264 0.573628 12.998 0.305183 12.4712C0.132079 12.1314 0.0630838 11.7697 0.0309362 11.3763C-1.59696e-05 10.9974 -8.62687e-06 10.5324 3.01904e-07 9.96891V4.03109C-8.62687e-06 3.46761 -1.59696e-05 3.00256 0.0309363 2.62372C0.063084 2.23025 0.132079 1.86856 0.305183 1.52883C0.573629 1.00197 1.00197 0.573628 1.52883 0.305182C1.86856 0.132079 2.23025 0.0630838 2.62372 0.0309362C3.00256 -1.59696e-05 3.46761 -8.62687e-06 4.03109 3.01904e-07ZM9.30503 3.00503C9.57839 2.73166 10.0216 2.73166 10.295 3.00503L13.795 6.50503C14.0683 6.77839 14.0683 7.22161 13.795 7.49497L10.295 10.995C10.0216 11.2683 9.57839 11.2683 9.30503 10.995C9.03166 10.7216 9.03166 10.2784 9.30503 10.005L11.61 7.7H4.9C4.5134 7.7 4.2 7.3866 4.2 7C4.2 6.6134 4.5134 6.3 4.9 6.3H11.61L9.30503 3.99497C9.03166 3.72161 9.03166 3.27839 9.30503 3.00503Z" fill="currentColor"/>
                            </svg>
                            <span class="ms-3">Logout</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</nav>
<!-- end header section -->