<?php
defined('FIR') OR exit();
/**
 * The template for displaying the footer section
 */
?>
<div class="auth-page-wrapper pt-5">
    <!-- auth page bg -->
    <div class="auth-one-bg-position auth-one-bg" id="auth-particles">
        <div class="bg-overlay"></div>

        <div class="shape">
            <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 1440 120">
                <path d="M 0,36 C 144,53.6 432,123.2 720,124 C 1008,124.8 1296,56.8 1440,40L1440 140L0 140z"></path>
            </svg>
        </div>
    </div>

    <!-- auth page content -->
    <div class="auth-page-content">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="text-center mt-sm-5 mb-4 text-white-50">
                        <div>
                            <a href="<?=$this->siteUrl()?>" class="d-inline-block auth-logo">
                                <img src="<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/logo/<?=e($this->siteSettings('logo'))?>" alt="" style="width: 235px;height: 100%;">>
                            </a>
                        </div>
                        <p class="mt-3 fs-15 fw-medium"><?=e($this->siteSettings('sitename'))?> - <?=e($this->siteSettings('title'))?></p>
                    </div>
                </div>
            </div>
            <!-- end row -->

            <div class="row justify-content-center">
                <div class="col-md-8 col-lg-6 col-xl-5">
                    <div class="card mt-4 card-bg-fill">

                        <div class="card-body p-4">
                            <div class="text-center mt-2">
                                <h5 class="text-primary">Admin Login</h5>
                                <p class="text-muted">Please sign in to continue.</p>
                            </div>

                            <div class="p-2 mt-4">
                                <form id="login-form">
                                    <div class="mb-3">
                                        <label for="email">Email address</label>
                                        <div class="form-icon">
                                            <input type="email" class="form-control form-control-icon" id="email" name="email" placeholder="Email address" autocomplete="off">
                                            <i class="ri-mail-unread-line"></i>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <div class="float-end">
                                            <a href="#" class="text-muted">Forgot password?</a>
                                        </div>

                                        <label class="form-label" for="password">Password</label>
                                        <div class="position-relative auth-pass-inputgroup mb-3">
                                            <input type="password" class="form-control pe-5 password-input" name="password" placeholder="Enter password" id="password" autocomplete="off">
                                            <button class="btn btn-link position-absolute end-0 top-0 text-decoration-none text-muted password-addon material-shadow-none" type="button" id="password-addon"><i class="ri-eye-fill align-middle"></i></button>
                                        </div>
                                    </div>

                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="auth-remember-check" name="remember">
                                        <label class="form-check-label" for="auth-remember-check">Remember me</label>
                                    </div>

                                    <div class="mt-4">
                                        <?=$this->token()?>
                                        <button id="loginBtn" class="btn btn-primary waves-effect waves-light w-100">Sign In</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- end card body -->
                    </div>
                    <!-- end card -->
                </div>
            </div>
            <!-- end row -->
        </div>
        <!-- end container -->
    </div>
    <!-- end auth page content -->

    <!-- footer -->
    <footer class="footer">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="text-center">
                        <p class="mb-0 text-muted">
                            Copyright © <?php echo(date('Y'))  ?> <a href="<?=$this->siteUrl(); ?>" class="text-muted"><?=e($this->siteSettings('sitename'))?>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!-- end Footer -->
</div>
<!-- end auth-page-wrapper -->