$(document).ready(function() {
    // Check if the timer exists
    var timer = $("#timer");
    if (timer.length > 0) {
        'use strict';

        var x = setInterval(function () {
            var now = Date.now(); // Current timestamp
            var timeRemaining = deadline - now; // Calculate time remaining in milliseconds

            // Calculate minutes and seconds
            var minutes = Math.floor((timeRemaining % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((timeRemaining % (1000 * 60)) / 1000);

            // Ensure minutes and seconds are within valid ranges
            if (isNaN(minutes) || isNaN(seconds)) {
                // If either minutes or seconds is NaN, set them to 0
                minutes = 0;
                seconds = 0;
            }

            // Update timer display
            document.getElementById("timer").innerHTML = minutes + "m :" + seconds + "s ";

            // Update progress bar width
            var progressBar = document.querySelector("#progressBar");
            progressBar.style.width = ((timeRemaining / (expireSec * 1000)) * 100) + "%";

            // If time is up
            if (timeRemaining <= 0) {
                clearInterval(x); // Stop the timer
                progressBar.style.width = "0%"; // Reset progress bar
                document.getElementById("timer").innerHTML = expireText; // Display "Expired"
                $(".submit-button").attr("disabled", true); // Disable buttons
            }
        }, 1000); // Update every second
    }
});
